// Decompiled by Jad v1.5.8g. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.kpdus.com/jad.html
// Decompiler options: packimports(3) braces deadcode 

package net.minecraft.src;

import java.util.List;
import java.util.Random;

// Referenced classes of package net.minecraft.src:
//            Block, World, EnumMobType, AxisAlignedBB, 
//            EntityLiving, EntityPlayer, IBlockAccess, Material, 
//            Entity

public class BlockTrap extends Block
{

    protected BlockTrap(int i, int j, Material material, boolean x)
    {
        super(i, j, material);
        crossed = x;
        float f = 0.0625F;
        setTickOnLoad(true);
    }

    public int tickRate()
    {
        return 40;
    }

    public boolean isOpaqueCube()
    {
        return false;
    }

    public boolean renderAsNormalBlock()
    {
        return false;
    }
    
    public int getRenderType()
    {
        return 1;
    }
    
    public int getRenderBlockPass()
    {
        return 0;
    }

    public boolean canPlaceBlockAt(World world, int i, int j, int k)
    {
        return world.isBlockNormalCube(i, j - 1, k);
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l)
    {
        if(!world.isBlockNormalCube(i, j - 1, k))
        {
        	dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
        }
    }
    
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k)
    {
        return getCollisionBoundingBoxFromPool(world,i,j,k);
    }
    
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k)
    {
    	if (!crossed)
    	{
    		float f = 0.7F;
            return AxisAlignedBB.getBoundingBoxFromPool((float)i, (float)j, (float)k, (float)(i+1), (float)(j + 1) - f, (float)(k+1));
    	}
    	else
    	{
    		float f = 0.3F;
    		float f1 = 0.15F;
            return AxisAlignedBB.getBoundingBoxFromPool((float)i+f1, (float)j, (float)k+f1, (float)(i+1)-f1, (float)(j + 1) - f, (float)(k+1)-f1);
    	}
        
    }

    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity)
    {
        if (crossed)
        {
        	return;
        }
        if (world.getBlockMetadata(i,j,k)==0)
    	{
        	world.scheduleUpdateTick(i, j, k, blockID, tickRate());
        	return;
    	}
        if ((entity instanceof EntityM4DMob || entity instanceof EntityMob) && !entity.isDead)
        {
        	int d = 1;
        	if (blockMaterial==Material.rock)
        	{
        		d=2;
        	}
        	if (blockMaterial==Material.iron)
        	{
        		d=4;
        	}
        	if (entity instanceof EntityMob)
        	{
        		entity.attackEntityFrom(null, 2*d);
        	}
        	else
        	{
            	entity.attackEntityFrom(null, d);
            	((EntityM4DMob)entity).trap(d);
        	}
        	entity.worldObj.playSoundAtEntity(entity, "beartrap", 1.0F, 1.0F / (world.rand.nextFloat() * 0.2F + 0.9F));
        	int newid=0;
        	if (blockMaterial==Material.wood)
        	{
        		dropBlockAsItem_do(world,i,j,k,new ItemStack(Item.stick));
        	}
        	if (blockMaterial==Material.rock)
        	{
        		if (world.rand.nextInt(4)==0)
        		{
        			dropBlockAsItem_do(world,i,j,k,new ItemStack(Item.stick));
        		}
        		else
        		{
        		newid=mod_Mine4Dead.blockTrapStoneX.blockID;
        		}
        	}
        	if (blockMaterial==Material.iron)
        	{
        		if (world.rand.nextInt(16)==0)
        		{
        			dropBlockAsItem_do(world,i,j,k,new ItemStack(Item.stick));
        		}
        		else
        		{
        		newid=mod_Mine4Dead.blockTrapIronX.blockID;
        		}
        	}
        	world.setBlockAndMetadataWithNotify(i,j,k,newid,0);
        }
    }
    
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer)
    {
    	if (crossed)
    	{
    		if (blockMaterial==Material.rock)
        	{
    			world.setBlockAndMetadataWithNotify(i, j, k, mod_Mine4Dead.blockTrapStone.blockID,0);
        	}
    		else
    		{
    			world.setBlockAndMetadataWithNotify(i, j, k, mod_Mine4Dead.blockTrapIron.blockID,0);
    		}
    		world.scheduleUpdateTick(i, j, k, blockID, tickRate());
    		return true;
    	}
    	return false;
    }
    
    public void updateTick(World world, int i, int j, int k, Random random)
    {
    	world.setBlockMetadata(i,j,k,1);
    }

    public void onBlockRemoval(World world, int i, int j, int k)
    {
        if(crossed)
        {
            world.notifyBlocksOfNeighborChange(i, j, k, blockID);
            world.notifyBlocksOfNeighborChange(i, j - 1, k, blockID);
        }
        super.onBlockRemoval(world, i, j, k);
    }

    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l)
    {
        return crossed;
    }

    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l)
    {
        if(!crossed)
        {
            return false;
        } else
        {
            return l == 1;
        }
    }

    public boolean canProvidePower()
    {
        return true;
    }

    public int idDropped(int i, Random random)
    {
    	if (!crossed)
    	{
    		return blockID;
    	}
    	if (blockMaterial==Material.rock)
    	{
    		return mod_Mine4Dead.blockTrapStone.blockID;
    	}
    	else
    	{
    		return mod_Mine4Dead.blockTrapIron.blockID;
    	}
    }
    
    private boolean crossed;
}
